<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('insurance_fees', function (Blueprint $table) {
            $table->id();
            $table->string('name')->comment('Name of the insurance fee');
            $table->text('description')->comment('Description of the insurance fee');
            $table->integer('issuance_amount')->comment('Amount of the insurance fee in percentage');
            $table->integer('marketers_amount')->comment('Amount of the insurance fee in percentage');
            $table->integer('commission')->comment('Amount of the insurance commission in percentage');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('insurance_fees');
    }
};
