<?php

use App\Models\InsuranceFee;
use Livewire\Volt\Component;
use Livewire\Attributes\Validate;

new class extends Component {

    #[Validate('required')]
    public $name;
    #[Validate('required')]
    public $issuance_amount;
    #[Validate('required')]
    public $marketers_amount;
    #[Validate('required')]
    public $description;
    #[Validate('required')]
    public $commission;

    public $insuranceFees;

    public function mount()
    {
        $this->insuranceFees = InsuranceFee::all();
    }
    public function createFee()
    {
        $validated = $this->validate();

        InsuranceFee::create($validated);

        $this->reset();

        session()->flash('success', __('Insurance fee created successfully.'));

        $this->insuranceFees = InsuranceFee::all();
    }

    public function deleteFee($id)
    {
        $fee = InsuranceFee::findOrFail($id);
        $fee->delete();

        session()->flash('success', __('Insurance fee deleted successfully.'));
        $this->insuranceFees = InsuranceFee::all();
    }
}; ?>

<div>

    <div class="block mb-10 p-6 bg-white border border-gray-200 rounded-lg shadow-sm  dark:bg-zinc-900 dark:border-zinc-900">
        <h4>{{ __('Insurance Fee') }}</h4>
        <form wire:submit="createFee" class="mb-3">
            <flux:field>
                <flux:input type="text" label="name" wire:model="name" />
                <flux:textarea type="text" label="description" wire:model="description" />
                <div class="grid grid-cols-3 gap-4">
                    <div>
                        <flux:input wire:model="issuance_amount" class="" type="number" label="issuance amount (%)" max="100" min="0" />
                    </div>
                    <div>
                        <flux:input wire:model="marketers_amount" class="" type="number" label="marketers amount (%)" max="100" min="0" />
                    </div>
                    <div>
                        <flux:input wire:model="commission" class="" type="number" label="commission (%)" max="100" min="0" />
                    </div>
                </div>
                <flux:button type="submit">
                    {{ __('submit') }}
                </flux:button>

                @if (session()->has('success'))
                <div class="mt-4 text-green-600">
                    {{ session('success') }}
                </div>
                @endif
            </flux:field>
        </form>
    </div>


    <div>
        <table class="table-auto w-full text-center border-collapse border border-gray-300">
            <thead>
                <tr class="">
                    <th class="border text-sm border-gray-300 px-4 py-2">{{ __('Name') }}</th>
                    <th class="border text-sm border-gray-300 px-4 py-2">{{ __('Issuance Amount (%)') }}</th>
                    <th class="border text-sm border-gray-300 px-4 py-2">{{ __('Marketers Amount (%)') }}</th>
                    <th class="border text-sm border-gray-300 px-4 py-2">{{ __('Commission (%)') }}</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                @foreach ($insuranceFees as $fee)
                <tr>
                    <td class="border border-gray-300 px-4 py-2">{{ $fee->name }}</td>
                    <td class="border border-gray-300 px-4 py-2">{{ $fee->issuance_amount }}%</td>
                    <td class="border border-gray-300 px-4 py-2">{{ $fee->marketers_amount }}%</td>
                    <td class="border border-gray-300 px-4 py-2">{{ $fee->commission }}%</td>
                    <td class="border border-gray-300 px-4 py-2">
                        <flux:button wire:click="deleteFee({{ $fee->id }})" variant="danger">
                            {{ __('Delete') }}
                        </flux:button>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
