<?php

use Livewire\Volt\Component;
use App\Models\RegisterSeller;

new class extends Component {
    public array $registeredSellers = [];

    public function mount()
    {
        $this->registeredSellers = RegisterSeller::all()->toArray();
    }
}; ?>

<div>


    <div class="relative overflow-x-auto">
        <table class="w-full text-sm rtl:text-right text-gray-500 dark:text-gray-400 text-center align-middle ">
            <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                <tr>
                    <th scope="col" class="px-6 py-3">
                        {{ __('name') }}
                    </th>
                    <th scope="col" class="px-6 py-3">
                        {{ __('phone') }}
                    </th>
                    <th scope="col" class="px-6 py-3">
                        {{ __('social_number') }}
                    </th>
                </tr>
            </thead>
            <tbody>
                @foreach ($registeredSellers as $seller )
                <tr class="bg-white border-b dark:bg-gray-800 dark:border-gray-700 border-gray-200">
                    <th scope="row" class="px-6 py-4 font-medium text-gray-900 whitespace-nowrap dark:text-white">
                        {{ $seller['first_name'] . ' ' . $seller['last_name'] }}
                    </th>
                    <td class="px-6 py-4">
                        {{ $seller['phone'] }}
                    </td>
                    <td class="px-6 py-4">
                        {{ $seller['social_number'] }}
                    </td>
                </tr>
                @endforeach

            </tbody>
        </table>
    </div>

</div>
