<?php

use Livewire\Volt\Component;
use App\Models\RegisterSeller;

new class extends Component {
    public string $first_name = '';
    public string $last_name = '';
    public string $phone = '';
    public string $social_number = '';

    public function submit()
    {
        $this->validate([
            'first_name' => 'required|string|max:255',
            'last_name' => 'required|string|max:255',
            'phone' => 'required|regex:/^09\d{9}$/',
            'social_number' => 'required|digits:10',
        ]);

        RegisterSeller::create([
            'first_name' => $this->first_name,
            'last_name' => $this->last_name,
            'phone' => $this->phone,
            'social_number' => $this->social_number,
        ]);

        $this->reset();
        session()->flash('success', 'ثبت‌نام با موفقیت انجام شد.');
    }
}; ?>

<div>
    @if (session()->has('success'))
    <div class="mb-4 p-4 bg-green-100 text-green-800 rounded-lg text-center">
        {{ session('success') }}
    </div>
    @endif
    <form wire:submit.prevent="submit" class="space-y-6">
        <div class="grid md:grid-cols-2 gap-6">
            <div>
                <label class="block text-lg font-bold text-gray-900 mb-3">نام</label>
                <input type="text" wire:model="first_name"
                    class="w-full px-4 py-3 border-2 border-gray-200 !rounded-button text-lg focus:border-primary focus:outline-none"
                    placeholder="نام خود را وارد کنید" required />
                @error('first_name') <span class="text-red-600 text-sm">{{ $message }}</span> @enderror
            </div>
            <div>
                <label class="block text-lg font-bold text-gray-900 mb-3">نام خانوادگی</label>
                <input type="text" wire:model="last_name"
                    class="w-full px-4 py-3 border-2 border-gray-200 !rounded-button text-lg focus:border-primary focus:outline-none"
                    placeholder="نام خانوادگی خود را وارد کنید" required />
                @error('last_name') <span class="text-red-600 text-sm">{{ $message }}</span> @enderror
            </div>
        </div>

        <div>
            <label class="block text-lg font-bold text-gray-900 mb-3">شماره موبایل</label>
            <input type="tel" wire:model="phone"
                class="w-full px-4 py-3 border-2 border-gray-200 !rounded-button text-lg focus:border-primary focus:outline-none"
                placeholder="09xxxxxxxxx" required />
            @error('phone') <span class="text-red-600 text-sm">{{ $message }}</span> @enderror
        </div>

        <div>
            <label class="block text-lg font-bold text-gray-900 mb-3">کد ملی</label>
            <input type="text" wire:model="social_number"
                class="w-full px-4 py-3 border-2 border-gray-200 !rounded-button text-lg focus:border-primary focus:outline-none"
                placeholder="کد ملی 10 رقمی" required />
            @error('social_number') <span class="text-red-600 text-sm">{{ $message }}</span> @enderror
        </div>

        <button type="submit"
            class="w-full bg-primary text-white px-8 py-4 !rounded-button text-xl font-bold hover:bg-blue-700 transition-colors whitespace-nowrap">
            ثبت‌نام و شروع کسب درآمد
        </button>
    </form>
</div>
