<!DOCTYPE html>
<html lang="fa" dir="rtl">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>برنامه ارجاع بیمه - با معرفی هر دوست، درآمد کسب کن!</title>
    <script src="https://cdn.tailwindcss.com/3.4.16"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@100..900&display=swap" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/remixicon/4.6.0/remixicon.min.css" />
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: "#1e40af",
                        secondary: "#059669",
                    },
                    borderRadius: {
                        none: "0px",
                        sm: "4px",
                        DEFAULT: "8px",
                        md: "12px",
                        lg: "16px",
                        xl: "20px",
                        "2xl": "24px",
                        "3xl": "32px",
                        full: "9999px",
                        button: "8px",
                    },
                    fontFamily: {
                        vazir: ["Vazirmatn", "sans-serif"],
                    },
                },
            },
        };
    </script>
    <style>
        :where([class^="ri-"])::before {
            content: "\f3c2";
        }

        * {
            scroll-behavior: smooth;

        }

        .hero-bg {
            background-image: url('https://readdy.ai/api/search-image?query=modern%20insurance%20office%20with%20professional%20Persian%20businesspeople%20handshaking%20and%20discussing%20insurance%20policies%2C%20clean%20minimalist%20background%2C%20soft%20lighting%2C%20professional%20atmosphere%2C%20blue%20and%20green%20color%20scheme%2C%20high%20quality%20photography&width=1920&height=800&seq=hero-insurance&orientation=landscape');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
        }
    </style>
</head>

<body class="bg-gray-50 font-vazir">
    <div>
        <!-- Header -->
        <section class="hero-bg relative min-h-[600px] flex items-center">
            <div class="absolute inset-0 bg-gradient-to-l from-primary/20 to-primary/60"></div>
            <div class="container mx-auto px-4 relative z-10">
                <div class="max-w-2xl mr-auto text-white">
                    <h1 class="text-4xl md:text-6xl font-bold mb-6 leading-tight">
                        با معرفی هر دوست،<br />
                        <span class="text-yellow-300">درآمد کسب کن!</span>
                    </h1>
                    <p class="text-xl mb-8 leading-relaxed opacity-90">
                        به عنوان بازاریاب بیمه ثبت‌نام کن و با معرفی دوستان، خانواده و
                        همکاران، پورسانت مناسب دریافت کن
                    </p>
                    <div class="flex flex-col sm:flex-row gap-4">
                        <a href="#register-seller-form"
                            class="bg-yellow-400 text-gray-900 px-8 py-4 !rounded-button text-lg font-bold hover:bg-yellow-300 transition-colors whitespace-nowrap">
                            همین حالا ثبت‌نام کن
                        </a>
                        <a href="#calculate"
                            class="border-2 border-white text-white px-8 py-4 !rounded-button text-lg font-bold hover:bg-white hover:text-primary transition-colors whitespace-nowrap">
                            محاسبه پورسانت
                        </a>
                    </div>
                </div>
            </div>
        </section>

        <!-- How It Works -->
        <section class="py-20 bg-white">
            <div class="container mx-auto px-4">
                <div class="text-center mb-16">
                    <h2 class="text-4xl font-bold text-gray-900 mb-4">
                        چگونه کار می‌کند؟
                    </h2>
                    <p class="text-xl text-gray-600">در سه مرحله ساده به درآمد برس</p>
                </div>
                <div class="grid md:grid-cols-3 gap-8">
                    <div class="text-center">
                        <div class="w-20 h-20 bg-primary rounded-full flex items-center justify-center mx-auto mb-6">
                            <i class="ri-user-add-line text-white text-2xl"></i>
                        </div>
                        <div
                            class="bg-primary text-white w-8 h-8 rounded-full flex items-center justify-center mx-auto mb-4 text-lg font-bold">
                            1
                        </div>
                        <h3 class="text-xl font-bold text-gray-900 mb-3">
                            ثبت‌نام به عنوان بازاریاب
                        </h3>
                        <p class="text-gray-600">
                            اطلاعات خود را تکمیل کنید و به عنوان بازاریاب بیمه فعالیت کنید
                        </p>
                    </div>
                    <div class="text-center">
                        <div class="w-20 h-20 bg-secondary rounded-full flex items-center justify-center mx-auto mb-6">
                            <i class="ri-group-line text-white text-2xl"></i>
                        </div>
                        <div
                            class="bg-secondary text-white w-8 h-8 rounded-full flex items-center justify-center mx-auto mb-4 text-lg font-bold">
                            2
                        </div>
                        <h3 class="text-xl font-bold text-gray-900 mb-3">
                            معرفی افراد دیگر
                        </h3>
                        <p class="text-gray-600">
                            دوستان، خانواده و همکاران خود را برای خرید بیمه معرفی کنید
                        </p>
                    </div>
                    <div class="text-center">
                        <div class="w-20 h-20 bg-yellow-500 rounded-full flex items-center justify-center mx-auto mb-6">
                            <i class="ri-money-dollar-circle-line text-white text-2xl"></i>
                        </div>
                        <div
                            class="bg-yellow-500 text-white w-8 h-8 rounded-full flex items-center justify-center mx-auto mb-4 text-lg font-bold">
                            3
                        </div>
                        <h3 class="text-xl font-bold text-gray-900 mb-3">دریافت پورسانت</h3>
                        <p class="text-gray-600">
                            به ازای هر خرید موفق، پورسانت خود را دریافت کنید
                        </p>
                    </div>
                </div>
            </div>
        </section>

        <!-- Commission Calculator with Alpine.js -->
        <section id="calculate" class="py-20 bg-gray-50" x-data="commissionCalculator()" x-init="calculate()">
            <div class="container mx-auto px-4">
                <div class="max-w-4xl mx-auto">
                    <!-- Header -->
                    <div class="text-center mb-12">
                        <h2 class="text-4xl font-bold text-gray-900 mb-4">
                            محاسبه پورسانت
                        </h2>
                        <p class="text-xl text-gray-600">
                            ببینید چقدر می‌توانید درآمد کسب کنید
                        </p>
                    </div>
                    <!-- Calculator Box -->
                    <div class="bg-white rounded-2xl p-8 shadow-xl">
                        <div class="grid md:grid-cols-2 gap-8">
                            <!-- Inputs -->
                            <div>
                                <!-- Insurance Amount -->
                                <div class="mb-6">
                                    <label for="insuranceAmount" class="block text-lg font-bold text-gray-900 mb-3">
                                        مبلغ بیمه (تومان)
                                    </label>
                                    <input
                                        type="number"
                                        id="insuranceAmount"
                                        x-model.number="insuranceAmount"
                                        @input="calculate"
                                        class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg text-lg focus:border-primary focus:ring-2 focus:ring-primary focus:outline-none transition"
                                        placeholder="مثال: 5000000" />
                                </div>
                                <!-- Insurance Type -->
                                <div class="mb-6">
                                    <span class="block text-lg font-bold text-gray-900 mb-3">نوع بیمه</span>
                                    <div class="flex flex-col gap-3">
                                        <template x-for="(type, index) in insuranceTypes" :key="index">
                                            <label class="flex items-center cursor-pointer group">
                                                <input type="radio" :value="index" x-model="selectedType" @change="calculate" class="hidden peer" />
                                                <span class="w-5 h-5 border-2 border-primary rounded-full ml-2 flex items-center justify-center peer-checked:bg-primary transition"></span>
                                                <span class="text-lg group-hover:text-primary transition" x-text="type.name"></span>
                                            </label>
                                        </template>
                                    </div>
                                </div>
                            </div>

                            <!-- Results -->
                            <div class="bg-gray-50 rounded-xl p-6 border border-gray-200">
                                <h3 class="text-xl font-bold text-gray-900 mb-4">
                                    محاسبه پورسانت شما
                                </h3>
                                <div class="space-y-4">
                                    <div class="flex justify-between items-center">
                                        <span class="text-gray-600">مبلغ اولیه:</span>
                                        <span class="font-bold" x-text="formatCurrency(insuranceAmount)"></span>
                                    </div>
                                    <?php if(false): ?>
                                    <div class="flex justify-between items-center text-red-600">
                                        <span>کسر ارزش افزوده (10%):</span>
                                        <span class="font-bold" x-text="formatCurrency(vat)"></span>
                                    </div>
                                    <div class="flex justify-between items-center text-red-600">
                                        <span>کسر مالیات (10%):</span>
                                        <span class="font-bold" x-text="formatCurrency(tax1)"></span>
                                    </div>
                                    <div class="border-t pt-3 flex justify-between items-center">
                                        <span class="text-gray-600">مبلغ باقی‌مانده:</span>
                                        <span class="font-bold" x-text="formatCurrency(remainingAfterTax)"></span>
                                    </div>
                                    <div class="flex justify-between items-center text-red-600">
                                        <span>کسر مالیات نهایی (10%):</span>
                                        <span class="font-bold" x-text="formatCurrency(tax2)"></span>
                                    </div>
                                    <?php endif; ?>

                                    <div class="border-t pt-3 flex justify-between items-center text-secondary text-2xl">
                                        <span class="font-bold">پورسانت شما:</span>
                                        <span class="font-bold" x-text="formatCurrency(finalCommission)"></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Insurance Types -->
        <section class="py-20 bg-white">
            <div class="container mx-auto px-4">
                <div class="text-center mb-16">
                    <h2 class="text-4xl font-bold text-gray-900 mb-4">انواع بیمه</h2>
                    <p class="text-xl text-gray-600">بیمه‌هایی که می‌توانید معرفی کنید</p>
                </div>
                <div class="grid md:grid-cols-2 gap-8 max-w-4xl mx-auto">
                    <div class="bg-gradient-to-br from-primary to-blue-600 rounded-2xl p-8 text-white">
                        <div class="w-16 h-16 bg-white/20 rounded-full flex items-center justify-center mb-6">
                            <i class="ri-car-line text-2xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold mb-4">بیمه شخص ثالث</h3>
                        <p class="text-lg mb-6 opacity-90">
                            بیمه اجباری خودرو که پوشش خسارات وارده به اشخاص ثالث را فراهم
                            می‌کند
                        </p>
                        <div class="bg-white/20 rounded-xl p-4">
                            <div class="text-center">
                                <div class="text-3xl font-bold text-yellow-300">70%</div>
                                <div class="text-sm opacity-80">پورسانت شما</div>
                            </div>
                        </div>
                    </div>
                    <div class="bg-gradient-to-br from-secondary to-green-600 rounded-2xl p-8 text-white">
                        <div class="w-16 h-16 bg-white/20 rounded-full flex items-center justify-center mb-6">
                            <i class="ri-shield-car-line text-2xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold mb-4">بیمه بدنه</h3>
                        <p class="text-lg mb-6 opacity-90">
                            بیمه اختیاری که پوشش خسارات وارده به خود خودرو را فراهم می‌کند
                        </p>
                        <div class="bg-white/20 rounded-xl p-4">
                            <div class="text-center">
                                <div class="text-3xl font-bold text-yellow-300">70%</div>
                                <div class="text-sm opacity-80">پورسانت شما</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- FAQ -->
        <section class="py-20 bg-gray-50">
            <div class="container mx-auto px-4">
                <div class="max-w-3xl mx-auto">
                    <div class="text-center mb-12">
                        <h2 class="text-4xl font-bold text-gray-900 mb-4">سوالات متداول</h2>
                        <p class="text-xl text-gray-600">
                            پاسخ سوالات رایج در مورد برنامه ارجاع
                        </p>
                    </div>
                    <div class="space-y-4">
                        <div class="bg-white rounded-xl overflow-hidden shadow-sm">
                            <button
                                class="w-full px-6 py-4 text-right flex justify-between items-center hover:bg-gray-50 transition-colors faq-toggle">
                                <span class="text-lg font-bold text-gray-900">آیا می‌توانم خودم را معرفی کنم؟</span>
                                <div class="w-6 h-6 flex items-center justify-center">
                                    <i class="ri-arrow-down-s-line text-xl transition-transform"></i>
                                </div>
                            </button>
                            <div class="px-6 pb-4 hidden faq-content">
                                <p class="text-gray-600">
                                    خیر، شما نمی‌توانید خودتان را معرفی کنید. این برنامه فقط برای
                                    معرفی افراد دیگر مانند دوستان، خانواده و همکاران طراحی شده
                                    است.
                                </p>
                            </div>
                        </div>
                        <div class="bg-white rounded-xl overflow-hidden shadow-sm">
                            <button
                                class="w-full px-6 py-4 text-right flex justify-between items-center hover:bg-gray-50 transition-colors faq-toggle">
                                <span class="text-lg font-bold text-gray-900">
                                    پورسانت‌ها چگونه واریز می‌شوند؟
                                </span>
                                <div class="w-6 h-6 flex items-center justify-center">
                                    <i class="ri-arrow-down-s-line text-xl transition-transform"></i>
                                </div>
                            </button>
                            <div class="px-6 pb-4 hidden faq-content">
                                <p class="text-gray-600">
                                    پورسانت‌ها پس از تأیید خرید بیمه و کسر مالیات و ارزش افزوده،
                                    به حساب بانکی ثبت شده شما واریز می‌شوند.
                                </p>
                            </div>
                        </div>
                        <div class="bg-white rounded-xl overflow-hidden shadow-sm">
                            <button
                                class="w-full px-6 py-4 text-right flex justify-between items-center hover:bg-gray-50 transition-colors faq-toggle">
                                <span class="text-lg font-bold text-gray-900">
                                    چقدر زمان می‌برد تا پورسانت واریز شود؟
                                </span>
                                <div class="w-6 h-6 flex items-center justify-center">
                                    <i class="ri-arrow-down-s-line text-xl transition-transform"></i>
                                </div>
                            </button>
                            <div class="px-6 pb-4 hidden faq-content">
                                <p class="text-gray-600">
                                    معمولاً پس از تأیید نهایی خرید بیمه، پورسانت شما ظرف 3 تا 5
                                    روز کاری به حساب شما واریز می‌شود.
                                </p>
                            </div>
                        </div>
                        <div class="bg-white rounded-xl overflow-hidden shadow-sm">
                            <button
                                class="w-full px-6 py-4 text-right flex justify-between items-center hover:bg-gray-50 transition-colors faq-toggle">
                                <span class="text-lg font-bold text-gray-900">
                                    آیا محدودیتی در تعداد معرفی وجود دارد؟
                                </span>
                                <div class="w-6 h-6 flex items-center justify-center">
                                    <i class="ri-arrow-down-s-line text-xl transition-transform"></i>
                                </div>
                            </button>
                            <div class="px-6 pb-4 hidden faq-content">
                                <p class="text-gray-600">
                                    خیر، هیچ محدودیتی در تعداد افرادی که می‌توانید معرفی کنید وجود
                                    ندارد. هرچه بیشتر معرفی کنید، درآمد بیشتری خواهید داشت.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>


        <!-- Registration Form -->
        <section class="py-20 bg-primary" id="register-seller-form">
            <div class="container mx-auto px-4">
                <div class="max-w-2xl mx-auto">
                    <div class="text-center mb-12">
                        <h2 class="text-4xl font-bold text-white mb-4">
                            همین الان شروع کن
                        </h2>
                        <p class="text-xl text-blue-100">
                            فرم زیر را تکمیل کن و به جمع بازاریاب موفق ما بپیوند
                        </p>
                    </div>
                    <div class="bg-white rounded-2xl p-8">
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('register-seller', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-2452885275-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    </div>
                </div>
            </div>
        </section>
    </div>



    <script id="calculator">
        //faq-toggle
        document.addEventListener("DOMContentLoaded", function() {
            const faqToggles = document.querySelectorAll(".faq-toggle");

            faqToggles.forEach((toggle) => {
                toggle.addEventListener("click", function() {
                    const content = this.nextElementSibling;
                    const icon = this.querySelector("i");

                    if (content.classList.contains("hidden")) {
                        content.classList.remove("hidden");
                        icon.style.transform = "rotate(180deg)";
                    } else {
                        content.classList.add("hidden");
                        icon.style.transform = "rotate(0deg)";
                    }
                });
            });
        });

        document.addEventListener("DOMContentLoaded", function() {
            const checkboxes = document.querySelectorAll(".insurance-type-checkbox");

            checkboxes.forEach((checkbox) => {
                checkbox.addEventListener("change", function() {
                    const indicator = this.parentElement.querySelector(
                        ".checkbox-indicator i",
                    );
                    indicator.style.opacity = this.checked ? "1" : "0";
                });
            });
        });
    </script>
    <script>
        function commissionCalculator() {
            return {
                insuranceAmount: 5000000,
                selectedType: 0,
                vat: 0,
                tax1: 0,
                tax2: 0,
                remainingAfterTax: 0,
                finalCommission: 0,
                insuranceTypes: [{
                        name: 'بیمه شخص ثالث',
                        issuance_amount: 3,
                        marketers_amount: 4,
                        description: '',
                        commission: 70
                    },
                    {
                        name: 'بیمه بدنه',
                        issuance_amount: 5,
                        marketers_amount: 10,
                        description: '',
                        commission: 70
                    }
                ],
                calculate() {
                    let base = this.insuranceAmount;
                    this.vat = base * 0.1;
                    let afterVat = base - this.vat;

                    this.tax1 = afterVat * 0.1;
                    let afterTax1 = afterVat - this.tax1;
                    this.remainingAfterTax = afterTax1;

                    let type = this.insuranceTypes[this.selectedType];
                    let percent = type.issuance_amount + type.marketers_amount;
                    let afterPercent = afterTax1 * (percent / 100);

                    this.tax2 = afterPercent * 0.1;
                    let afterTax2 = afterPercent - this.tax2;

                    this.finalCommission = afterTax2 * (type.commission / 100);
                },
                formatCurrency(value) {
                    return new Intl.NumberFormat('fa-IR').format(Math.round(value)) + ' تومان';
                }
            }
        }
    </script>
</body>

</html>
<?php /**PATH D:\_projects\Laravel\InsureEarn\resources\views/home.blade.php ENDPATH**/ ?>